"""User model for authentication and RBAC."""

from enum import Enum
from typing import Optional
from pydantic import BaseModel, Field


class Role(str, Enum):
    ADMIN = "Admin"
    MANAGER = "Manager"
    STAFF = "Staff"


class User(BaseModel):
    id: Optional[int] = Field(default=None)
    username: str
    hashed_password: str
    role: Role
    full_name: Optional[str] = None
    email: Optional[str] = None

    class Config:
        orm_mode = True